/**********************************************
 * Library functions to show the bit          *
 * representation of various variable         *
 * types                                      *
 *                                            *
 * Supported types:                           *
 * unsigned char   (8 bits)                   *
 * unsigned short  (16 bits)                  *
 * unsigned int    (32 bits)                  * 
 * float           (32 bits)                  *    
 * double          (64 bits)                  *
 *                                            *
 * Note: for floating point single &          *
 *       double precision the display         *
 *       follows the IEEE 754 standard        *
 *       breaking the number into either      *
 *                                            *
 * (single precision)                         *
 * signbit + 8 bit exponent + 23 bit mantissa *
 * (double precision)                         *
 * sign + 11 bit exponent + 52 bit mantissa   *
 **********************************************/

int display_char(unsigned char word)
{
  int i,count;

  count=0;

  for(i=7;i!=-1;i--)
    {
      if((1<<i)&word)
	{
	  printf("1");
	}
      else
	{
	  printf("0");
	}
      count++;
      if(count==4)
	{
	  printf(" ");
	  count=0;
	}
    }

  return (int)word;
}


int display_short(unsigned short int word)
{
  int i,count;

  count=0;
  
  for(i=15;i!=-1;i--)
    {
      if((1<<i)&word)
	{
	  printf("1");
	}
      else
	{
	  printf("0");
	}
      count++;
      if(count==4)
	{
	  printf(" ");
	  count=0;
	}
    }

  return (int)word;
}

int display_int(unsigned int word)
{
  int i,count;
  
  count=0;

  for(i=31;i!=-1;i--)
    {
      if((1<<i)&word)
	{
	  printf("1");
	}
      else
	{
	  printf("0");
	}
      count++;
      if(count==4)
	{
	  printf(" ");
	  count=0;
	}
    }

  return (int)word;
}
 
int display_float(float fword)
{
  int i,count;
  unsigned int* word;

  count=0;
  word = (unsigned int*)&fword;

  for(i=31;i!=-1;i--)
    {
      if(((1<<i)&(*word)))
	{
	  printf("1");
	}
      else
	{
	  printf("0");
	}
      count++;
      if(count==4||i==31)
	{
	  printf(" ");
	  count=0;
	}
      if(i==23)
	{
	  printf("\t");
	  count=0;
	}
    }

  return *word;
}   

int display_double(double fword)
{
  int i,count;
  unsigned int* word;
  unsigned int* dword;

  count=0;
  dword = (unsigned int*)&fword;
  word = ((unsigned int*)&fword)+1;
  for(i=31;i!=-1;i--)
    {
      if(((1<<i)&(*word)))
	{
	  printf("1");
	}
      else
	{
	  printf("0");
	}
      count++;
      if(count==4||i==31)
	{
	  printf(" ");
	  count=0;
	}
      if(i==20)
	{
	  printf("\t");
	  count=0;
	}
    }

  for(i=31;i!=-1;i--)
    {
      if(((1<<i)&(*dword)))
	{
	  printf("1");
	}
      else
	{
	  printf("0");
	}
      count++;
      if(count==4)
	{
	  printf(" ");
	  count=0;
	}
    }

  return *word;
}   
