#ifndef BINARY_DISPLAY_H
#define BINARY_DISPLAY_H

/**********************************************
 * Library functions to show the bit          *
 * representation of various variable         *
 * types                                      *
 *                                            *
 * Supported types:                           *
 * unsigned char   (8 bits)                   *
 * unsigned short  (16 bits)                  *
 * unsigned int    (32 bits)                  * 
 * float           (32 bits)                  *    
 * double          (64 bits)                  *
 *                                            *
 * Note: for floating point single &          *
 *       double precision the display         *
 *       follows the IEEE 754 standard        *
 *       breaking the number into either      *
 *                                            *
 *            (single precision)              *
 * signbit + 8 bit exponent + 23 bit mantissa *
 *            (double precision)              *
 * sign + 11 bit exponent + 52 bit mantissa   *
 **********************************************/

int display_char(unsigned char);
int display_short(unsigned short int);
int display_int(unsigned int);
int display_float(float);
int display_double(double);

#endif
